Annual Review of Sociology

# Tracking US Social Change Over a Half-Century: The General Social Survey at Fifty

Peter V. Marsden,1 Tom W. Smith,² and Michael Hout3

1Department of Sociology,Harvard University, Cambridge,Massachusetts O2138,USA; email: pvm@wjh.harvard.edu 2NORC at the Universityof Chicago,Chicago,Ilinois 6063,USA 3Departmentof Sociology,New York UniversityNew York,NY10012,USA

First published as a Review in Advance on April 29,2020

TheAnnual Review ofSociology isonlineat soc.annualreviews.org

https://doi.org/10.1146/annurev-soc-121919- 054838

Copyright $\circledcirc 2 0 2 0$ by Annual Reviews. All rights reserved

# ANMIEWS CONNECT

# www.annualreviews.org

# Keywords

·Download figures   
· Navigate cited references   
· Keyword search   
· Explore relatedarticles   
· Share via email or social media

atitudes, inequality,religion,social capital, socialchange

# Abstract

In the five decades since its inception in 1971, the General Social Survey (GSS) project has prospectively recorded the current characteristics, backgrounds, behaviors, and attitudes of representative cross sections of American adults covering more than two generations and more than a century of birth cohorts. A foundational resource for contemporary social science, the data it produces and disseminates enable social scientists to develop broad and deep understandings into the changing fabric of US society, and aid legions of instructors and students in teaching and learning. It facilitates internationally comparative survey research and places the United States in the context of other societies through the International Social Survey Program, which it cofounded. This article first recounts the GSS's origins, design,and development. It then surveys contributions based on GSS data to studies of stratification and inequality, religion, sociopolitical trends, intergroup relations, social capital and social networks, health and well-being, culture, and methodology.

# OVERVIEW

Conceived in 1971,the General Social Survey (GSS) project completes its fiftieth year in 2020.It is among the most widely used databases in contemporary social science.The data it collects,augments,and disseminates enable social scientists to trace and dissect over-time trends that reveal the changing fabric of US society,and to compare the United States with numerous other societies. It is also employed extensively by instructors and students for teaching and learning.This review first recounts the GSS's initial development, subsequent elaboration,and design.Thereafter it selectively surveys cross-sectional, trend, and comparative studies based on GSS data, as well as some important methodological contributions resting on them.These fall within numerous fields of sociological interest, including inequality,religion and religiosity,social and political orientations,intergroup relations, social capital and social networks,health and well-being,and culture.

# ORIGINS, OBJECTIVES,ANDDESIGN

GSS founderJames A.Davis's proposal to the National Science Foundation("Twenty-Some Questions: A National Data Program for Sociology") led to the first (1972) GSS.Writing when data were scarce and closely held,Davis stressed widespread and timely dissemination of a modest body of high-quality survey data to facilitate research, replication,and teaching. He argued for measuring 25 background characteristics (e.g., education, race, marital status) and 9 atitude/opinion items (on, e.g., race relations, happiness,and interpersonal trust),advocating that measurements come from prior national surveys so that trends could be assessed immediately. He proposed that they be included in an ongoing national survey also covering other topics.Early GSSs included many more items than those 34,and by 1977 the GSS became a stand-alone survey.

Aspirations Davis articulated—to monitor trends and widely distribute data—remain among the GSS's primary objectives. Success in dissemination depends on engaging the interest and initiative of practicing social scientists; the review below demonstrates that this has been amply forthcoming.

To pursue these goals, the GSS follows a repeated cross-sectional design,optimal for assessing aggregate over-time change in a population. Each GSS round draws a fresh representative sample of noninstitutionalized US adults; in-person interviews (including some self-administered segments) are its preferred data collection mode. Only English-speaking Americans were represented until 2006, when Spanish speakers were added. Conducted almost annuall until 1993 and biennially (with larger samples) since 1994,it tracks trends by replicating the wording of a“core" set of items verbatim over time.Pooling data across adjacent-in-time cross sections yields appreciably sized samples of proportionately small groups (e.g.,Asian Americans,sexual minorities); several such samples can be compared across periods to assess subgroup trends.

To augment this design,in 1977 the project added single-occasion topical modules that examine new subjects (e.g., social networks) or investigate existing ones (e.g., race relations) in greater depth.These introduce innovation alongside the continuity provided by the repeated core items, leading to significant cross-sectional studies. Many items subsequently added to the replicating core first appeared within topical modules.

Following early-198Os bilateral German-American collaboration,the GSS—together with several overseas survey organizations—established the International Social Survey Program (ISSP). ISSP annually develops a collaboratively designed module (about,e.g.,social inequality or the environment) administered since 1985 in the GSS and similar surveys elsewhere.This added a third aim to the project: placing the United States in the context of other societies via comparative survey research.

Additionally, the GSS regularly conducts survey experiments addressing both substantive and methodological questions.Between 2O06 and 2014,it incorporated a panel component that reinterviewed respondents two and four years after they were first sampled.Several auxiliary studies of groups linked to GSS respondents—including work establishments (Kalleberg et al.1996) and religious congregations (Chaves 2O04)—branch out of the GSS.

Among the GSS's most valuable assets is the range of attitude and behavior data it collects, together with its wide and deep body of background information; it obtains extensive descriptions of the current social positions and social origins of its respondents,and of spouses/partners for those who are married/cohabiting.Increasingly it links respondent-provided survey data with other individual- and contextual-level (e.g.,residential area) information from sources like voter registration records and the US Census.Many paradata documenting the data collection process are available.The GSS takes great care to ensure the over-time comparability of measures for trend analyses. It assgns high priority to survey quality, maintaining response rates far above the survey industry standard, closely monitoring field efforts,and implementing numerous qualitycontrol measures.

# OVERVIEWSOFGSS-BASEDRESEARCH

A vast research literature rests on GSS data.As of August 2O19, the GSS project had confirmed more than 32,000 usages,including about 14,000 journal articles and 7,50o books. About half of these are in sociology, with most of the remainder distributed across other social sciences, including multidisciplinary fields like education,law,and public health.Hence,our review must be highly selective.We chose to emphasize works that are sociological, examine trends,are widely cited,and/or are recent. Space limitations preclude us from reviewing al of this sizable body of material; in most areas we can only highlight selections from it.We discuss only works based on GSS data, neglecting many important works about the subjects covered here that rest on other sources.

# Multitopic Trend Studies

Several studies assess trends in numerous GSS measures to generalize about directions of US opinion change. Combining GSS with other data dating from the late 193Os,Smith (1990b) found that liberally-oriented changes—especially regarding equal rights and individual choicepredominated. Exceptions included conservative trends on crime,spending/taxation,and social welfare.Many liberal trends moderated or reversed in the 1970s.Davis (1992) reported similar findings for 42 GSS series spanning 1972-1989,asserting that the 1980s saw a“liberal rebound,” and later (Davis 2013) extended this conclusion through 2010.Fischer & Hout (2006),too, concluded that liberalization was more common.

Hout (2020) recently examined 276 GSS items,almost all of which exhibit some change over all or part of the 1972-2018 time span. We discuss many of these in more depth below; among the largest are declines in newspaper reading,racial intolerance,disapproval of homosexuality, and opposition to legalized marijuana. Change was rarely uniform in either direction or pace, but more often toward liberal than conservative positions.

Many items tracked by the GSS are not readily arrayed along a conservative-liberal continuum. Studies collected by Marsden (2O12) examine trends in numerous orientations and behaviors, including sociopolitical atitudes as wellas informal socializing,institutional confidence,religiosity, subjective well-being,and verbal achievement.

Generally speaking,analyses of the GSS reveal most social change to be gradual rather than abrupt. Cohort turnover—the replacement of earlier-born, usually older, persons by more recently-born younger ones (Firebaugh 1989)—contributes notably to many trends.Davis (2013) suggested that liberalizing tendencies linked to cohort replacement have slowed,largely because cohort-related increases in education became smaller. The competing process of intracohort, within-person change—due to aging and period diferences combined—can counter cohort replacement, dampening the overall pace of change. Job satisfaction, for example,remains largely level overall: Fals due to cohort replacement are balanced by intracohort increases (Firebaugh & Harley 1995). The two processes may reinforce one another, however,leading to relatively rapid change at the population level; examples include orientations toward homosexuality (Baunach 2011)and views about legalizing marijuana (Felson et al.2019).

# Polarization

Beyond the general direction of attitude trends is the question of whether groups of Americans are increasingly separated from and in contention with one another.DiMaggio et al. (1996) examine this using 1974-1994 GSS data on social issues,defining polarization multidimensionally to include rising variability and bimodality in orientations,and increased between-group differences in average atitudes.They report litle evidence of polarization, exceptions being abortion rights and differences between Democratic and Republican identifiers. Evans's (2O03) replication over a longer time period yielded further signs of polarization—around issues of both sexual morality and abortion rights-and more widespread evidence of widening partisan differences (see also Manza et al.2012).Bolzendahl & Brooks (2005) report similar findings about growing differences by religious afiliation in attitudes about premarital sex and abortion rights.Fischer & Hout (2006) outline a diffusion model for atitude change,under which innovator (e.g., younger, more educated,or urban) groups lead the adoption of new views (on, e.g. gender role attitudes), but intergroup diferences subsequently shrink as a consensus is reached. This process need not be one-directional,as contention over abortion rights illustrate.

Miller & Hoffmann (1999) suggest that separation may be based more on identities than particular issues, showing that between 1975 and 1996 adherents of conservative religious groups increasingly labeled themselves as political conservatives. Chaves (2O17) reports a growing association between church attendance and political, social,and religious conservatism through 2014. Manza et al. (2O12) document a rising tendency for self-labeled conservatives to identify as Republicans,together with widening diferences between parties on certain social issues.The review below identifies additional instances of polarization,especially by political afiliation.

Most research based on the GSS focuses on particular substantive domains.In what follows, we selectively call attention to contributions in several fields of central interest within sociology. We amplify some points using tabulations we obtained via the online analysis tools in https:// sda.berkeley.edu,one of many sites that disseminate GSS data (among other widely used social science databases).

# STRATIFICATION ANDINEQUALITY

The extent of,and balance between,ascriptive factors—including socioeconomic origins,race,and gender/sexuality-and achieved ones in generating inequality are of perennial and vital interest to understanding it.While relevant research draws on numerous data sources,the GSS's extensive social origin data and repeated cross-sectional design make it valuable for studying trends in intergenerational mobility and status attainment.Its abundant information on sociopolitical attitudes and behaviors allows investigation of how numerous phenomena correspond with axes of differentiation and stratification. Weeden & Grusky (2012),for example,show that attitudes are decreasingly associated with “big-class”differences (e.g.，between professionals and laborers), while those linked to smaller occupational “microclasses”(e.g., accountants,cosmetologists, lawyers) are stable. Additionally, the GSS tracks American assessments of inequalities.

# Social Mobility and Status Attainment

Overall intergenerational mobility remained steady for 1972-1985,as increased fluidity due to falling status inheritance balanced lower structurally induced mobility traceable to occupational upgrading; among college graduates,occupational destinations were independent of origins (Hout 1988). Torche (2011) reexamined this finding for 1996-2006,replicating it in many respects but also reporting the emergence of an intergenerational association among advanced degree holders. She therefore questions universalistic/meritocratic interpretations of mobility trends within educational elites.Studying 1972-2012 GSS data,Pfeffer & Hertel (2015)found rising social fluidity, as the number of college-educated persons subject to weaker regimes of status inheritance grew. Beller (2oo9)questions the conventional practice of using only paternal characteristics to measure social origins. After incorporating maternal data, she reports a higher intergenerational association for 1994-2006; failing to do so obscured a rise in socioeconomic ascription among men born after 1965.Hout's (2018) study of the 1994-2016 period revealed continued intergenerational persistence in occupational standing; coupled with reductions in mobility due to occupational transformation,this implies lowered upward mobility for post-1960s birth cohorts.

Grusky & DiPrete (1990) examine variation in status attainment processes over the 1972-1987 period.Race differences in occupational attainment fel,as did those by gender-the latter reflecting deterioration among men more than improvements for women.Poorly educated workers fared least well.These reductions in ascription were greater in the 197Os; the authors associate this with the more conservative political agenda of the 1980s (DiPrete & Grusky 1990).

# Educational Attainment

Education's pivotal role in attainment and mobility warrants attention to trends in access to it. Pfeffer & Hertel (2O15) report that educational inequality by occupational class origins remained stable during 1972-2012,notwithstanding educational expansion; Hout & Janus (2011) reach similar conclusions about educational opportunity by educational origins.Buchmann & DiPrete (2006) show that once-higher college completion rates among men shifted to favor women in the late twentieth century, largely because of changes within origin families in which fathers are either absent or less educated; litle change occurred in families with better-educated fathers, where sons and daughters received bachelor ofarts degrees at nearly equal rates.Black-white inequality in years of education and high school completion fell across twentieth-century birth cohorts (Long et al. 2012),though racial disparities in collge completion rose.Long et al.attribute this convergence to social policy interventions—especially school funding—rather than to altered family background differences.

# Income Inequality

Among studies bearing on income inequality is one showing that between-class earnings differentials rose markedly between 1980 and 2010 (Wodtke 2016).Earned income grew more rapidly for proprietors and managers—especially those linked to larger organizations—than among ordinary employees or independent producers.Another literature uses GSS sexual behavior data to study variations in wages by sexual orientation.It finds that gay men are paid less than heterosexual men, while lesbian women outearn heterosexual ones (Black etal. 2003). Mize (2016) extends this to encompass bisexuality,demonstrating that bisexual men and women alike experience wage penalties.

# Class Identification

Distinct from objective statuses like education,occupation,and income are perceptions of social standing. Since 1972,roughly half of GSS interviewees identified themselves as lower or working class,and half as middle or upper class.The split rises and falls over time: A rise in lower/workingclass identification followed the Great Recesson that began in 2Oo8,and the lower-class fraction (about $8 \%$ in 2018) is yet to revert. Higher objective attainments predict middle/upper-class identification: Education and income receive greater weight than occupational standing. Selfemployed persons and those exercising authority over others tend to place themselves in the middle/upper class (Vanneman & Cannon 1987).

Identification with higher classes is less common among blacks than whites (Vanneman & Cannon 1987).Hunt & Ray's (2012) trend study through 2010 found that middle-class identification among blacks rose, in keeping with objective gains.Self-employment emerged as a predictor of middle-class identification by blacks in the 199Os and 2000s.

Investigations of gender differences in class identification highlight processes within couples, capitalizing on the GSS's spousal data. Davis & Robinson (1988) reported that identification by married women rested largely on their husbands’ characteristics in the 197Os but moved toward according equal emphasis to their own atributes in the 198Os; men relied mainly on their own attributes when placing themselves. Yamaguchi & Wang (2oo2) found that class placements by spouses in dual-earner couples weight their earnings in the same way and emphasize the husband's rather than the wife's occupation.Men take only their own education into account, while selfemployed women are especially apt to stress their own attributes rather than their husbands'.

# Verbal Achievement

The GSS assesses vocabulary knowledge—often used to indicate cognitive skills and verbal achievement—via ten multiple-choice items.People who are white,are non-Southern, have advantaged social origins, have fewer siblings,and have more education tend to score higher (Alwin 1991).Age differences are detectable but slight,yielding litle evidence ofcognitive aging (Alwin & McCammon 1999).Net of these factors,verbal achievement declined among post-World War II birth cohorts (Alwin 1991, Yang & Land 2006).Huang's (2009) analysis suggests that black-white differences in scores are partially attributable to interview circumstances: Scores among blacks interviewed by whites were lower than for those matched to black interviewers.

# Orientations Toward Income Inequality

The most extensive examination of GSS data on attitudes about income inequality (McCall 2013) finds that concern over the size and equitability of income differences was high between 1987 and 2010.McCall contends that many Americans view income differentials as problematic despite their widespread beliefin principles of equal opportunity. Indeed,preferences for reducing income inequality rise when it is perceived to rest on unfair grounds (e.g.,social connections or origins) or to be opportunity-limiting.

Svalfors (1997) drew on ISSP data to compare US attitudes toward income redistribution with those in seven high-income countries, finding Americans least likely to regard equalizing incomes or a guaranteed basic income as governmental responsibilities. US respondents regarded a larger extent of income dispersion across occupations as legitimate than did those elsewhere.Another ISSP-based study (Osberg & Smeeding 2Oo6) found that Americans,on average,were neither especially more likely nor unlikely than people elsewhere to regard income differences as too high. Distinctive,however, is that US perceptions of the correspondence between actual and equitable earned incomes are divided: A notable—and evidently growing-group views existing diferences as justified,while another favors substantial compression of inequalities. Greater consensus on the desirability of some reduction exists in other countries.

# RELIGIONANDRELIGIOSITY

Because the US Census and many other US-government-collected databases studied by social scientists do not collect information about religion,the GSS is especially important for this feld.Key studies of religious change and of how religion links with other sociopolitical orientations rest on its measures of religious afliation,behavior,and belief.Its detailed data on religious affiliation— for the respondent when interviewed and at age 16,the spouse or partner,and the parents—capture heterogeneity within Protestantism and Judaism.We highlight some of the many important findings within particular religious domains and close by summarizing trends within this institutional sector.

# Religious Affliation

Among the most notable religious changes during the period covered by the GSS is a redistribution of Americans among major denominations (Fischer & Hout 2006,Smith & Kim 2005).The proportion afiliated with Protestantism—especially “mainline” groups—fell, while that linked to conservative Protestant groups rose.Smith & Kim (2O05) trace this decline largely to lower retention of persons raised as Protestants. Hout et al. (20o1) attribute the growth among conservative groups principally to higher fertility, discounting switching from mainline to conservative groups.

Additionally, the fraction claiming no religious afliation increased markedly.Hout & Fischer (2002) find most religious “nones"to be unchurched believers who subscribe to many conventional Christian beliefs but rarely attend services (see also Chaves 2O17). They suggest that much of the rise in nonafiliation has political roots,maintaining that political moderates and liberals distance themselves from the association of organized religion with conservative politics by claiming to have no religion.

# Behaviors and Beliefs

Numerous scholars employ the GSS to study trends in religious service attendance.Hout & Greeley (1987) merged GSS data through 1984 with previous surveys beginning in 1939,finding that attendance was essentially stable,excepting a short-term post-1968 decline among Catholics. More recently, Chaves (2017) reports a modest overall decline that Schwadel (2011) attributes to cohort differences.

Several authors, including Greeley (1989) and Chaves (2017),conclude that most religious beliefs are relatively stable.Belief in life after death may be an exception (Greeley & Hout 1999); it rose between the 1970s and 1990s, principally among Catholics and Jewish people. Over a longer time frame,Schwadel (2O11) also found rising belief in an afterlife,together with cohort- and period-related declines in biblical literalism.

Much attention has been devoted to group diferences in religiosity. Schwadel (2011),among others,finds that most religious behaviors and beliefs rise with age.Several studies use GSS data in attempting to explain higher levels of religiosity among women. Miller & Stark (2O02) draw on them in assessng and rejecting gender-role socialization as an account, then proposing the alternative that women are more averse to risks of irreligiousness,such as divine punishment during a postlife.Roth & Kroll (2007) likewise employ GSS data to critique Miller & Stark's risk preference argument.

# Secularization

The secularization thesis,asserting that religious commitments and institutions decline with modernization,development,and rationalization—at least in Western industrialized societies— provides a backdrop for much thinking about religious trends.Greeley (1989) assessed religious change from the mid-1940s until the mid-1980s,combining GSS data with pre-1972 surveys that included identically worded questions.He found stability rather than decline in most religious beliefs and behaviors; exceptions were a steady erosion of membership in mainline Protestant denominations,and some short-term declines among Catholics in church attendance,financial support,and biblical literalism.

While acknowledging that the United States remains a comparatively religious nation and replicating many of Greeley's findings, Chaves's (2017) more recent analyses covering 1972-2014 do conclude that American religion has declined,if slowly.No indicator of religiosity he examined was rising.Among those found to be falling are afliation with any religious group,confident belief in God, biblicalliteralism,and attendance at worship services.As well, public confidence in religious leaders has fallen sharply. Voas & Chaves (2O16)reinforce these findings and place them in internationalcontext via comparisons with three other English-speaking countries,demonstrating that a process of religious decline driven by cohort replacement is underway in allfour and concluding that the United States is not an exception to the secularization thesis.Notwithstanding the overall declines,Schnabel & Bock (2O17) dispute this,using ISSP data to argue that intense religiosity persists in the United States, but not elsewhere.Falloffs were among the moderately religious, suggesting that US religiosity is polarizing.

# SOCIOPOLITICAL ATTITUDESANDORIENTATIONS

The GSS regularly measures political party preference,liberal-conservative self-identification, and retrospectively reported presidential voting.It elicits priorities for greater or less spending in several policy areas, views about government intervention,and opinions about numerous social issues.We highlight findings about many of these issue arenas here.

# Governmental Role

Foundational among political orientations are views about the balance between government and individual responsibility for social problems.The GSS has tracked these since the mid-1970s for issues like health care financing and living standards for the poor; Brooks & Manza (2013) show that they have fluctuated since the mid-198Os.These fluctuations do not correspond with macropolity theory, which anticipates that recessions stimulate greater demand for government and expansions prompt the opposite. Viewpoints about government's appropriate scope are instead polarized by partisan identity, especially in the wake of the Great Recession.

Bobo (1991) highlights a substantial group of Americans who regard redressng inequality as a collective responsibility and support an expanded role for government. McCall (2013) reconciles limited support for governmental efforts to reduce income differences (via, e.g., taxing higher incomes) with high concern over rising income inequality by reasoning that Americans support social policies that heighten and restore opportunity rather than redistribute income directly.Like others (Manza et al.2O12) she calls attention to rising support for national spending in domains such as education. Owens & Pedulla (2O14) employ GSS panel data in demonstrating that job or income loss during the Great Recession increased individual-level preferences for governmentled income redistribution but did not increase demand for spending in domestic arenas such as transportation or parks.

# Crime, Punishment, and Firearms

More than half of GSS respondents assign high priority to increasing spending on crime control, though this fraction fell somewhat following a decline in violent crime rates that began in the mid-1990s (Wright et al. 2012). After trending upward beginning in the 1970s, punitiveness— supporting capital punishment for convicted murderers and viewing courts as too lenientlikewise dropped,though both remain majority-held positions.Since 2Ooo,the percentage viewing courts as“too harsh”has nearly doubled,to about $2 0 \%$ ：

The GSS asks respondents about a hypothetical law requiring that a police permit be obtained before purchasing a gun. Wright et al. (2O12) report generall rising support through 2006, to above $8 0 \%$ ; it has since fallen below $7 5 \%$ .Women and blacks tend to be more favorable,though race and gender gaps narrowed over time. Miller (2019) examines trends through 2016, finding lower support among Republicans,rural dwellers,and gun owners.Partisan differences widen beginning around 2ooo,but more than half of strong Republicans nonetheless favored permits in 2016.

# Tolerance and Civil Liberties

A long-standing strategy for assessing tolerance examines the willingness to deny ordinary civil rights like freedom of speech to nonmainstream target groups including Communists and racists. One of the first GSS-based articles (Davis 1975) finds a substantial rise in tolerance by 1972- 1973 compared with Stoufer's (1955) study that used identical measurements.Davis finds cohort replacement—largely mediated by education—responsible for much of the increase. Bobo & Licari (1989) attribute many educational differences to cognitive sophistication,also reporting that education heightened tolerance even among those who dislike a target.Moore & Ovadia (2006) study contextual influences: Tolerance was higher among those living near many college graduates and lower for those close to numerous conservative Protestants.Twenge et al. (2O15) find rising tolerance trends through 2010, varying notably across target groups—steepest for homosexuals, but virtually flat for racist expression.

# Abortion and Sexual Morality

Much of what evidence exists for polarization involves social issues, especially abortion rights. Hout (1999) traces the emergence of abortion as a matter of ideological partisanship over the first two GSS decades.He highlights the rising role of conservative views-especially among women. Standpoints on abortion also reflect religious differences and attitudes regarding gender roles and sexual morality. Though divisions over abortion rights have become more marked, no strong trends toward more or less support are evident. Assessments of the morality of homosexual behavior and premarital sex have liberalized (Harding & Jencks 2O03,Loftus 2Oo1),while views regarding extramarital sex and prohibition of pornography remained largely stable.

Religious influences on this domain of attitudes have drawn substantial attention.Sherkat & Ellison (1997) contend that conservative Protestant opposition to pornography reflects cognitive structures prompted by beliefs in biblical inerrancy, including moral absolutism and sin as a source of social contamination. Barkan (2O14) argues that women's greater religiosity partially masks their higher support for abortion rights.Linking GSS data to county-level information, Adamczyk & Valdimarsdóttir (2018) report that both religious and nonreligious people exhibit more conservative abortion attitudes in places where religious service attendance is high.

# Environment

The longest-standing GSS trend about environmental issues concerns the environment as a priority for national spending.Support for this has fluctuated, with a nadir around 198O and a peak in the 1990s (e.g.,Pampel & Hunter 2012). The baby boom cohort assigns greater emphasis to the environment than do others (Johnson & Schwadel 2019,Pampel & Hunter 2012).McCright et al. (2014)report that differences in views about environmental spending based on partisanship and political ideology grew increasingly divergent after the early 1990s.

Dietz et al.'s (1998) framework for understanding environmental concern involves sociodemographic background,general worldviews,and environment-specific beliefs.Analyses of 1993 ISSP module data for the United States showed that worldviews and environmental beliefs best predict environmentally oriented behaviors.Sherkat& Elison (2Oo7) focus on how religious schemata are transformed into environmental beliefs and behaviors,finding,for example,that believing in biblical inerrancy can prompt a stewardship orientation toward the environment. Pampel & Hunter (2012),drawing on Fischer & Hout's (2006) diffusion model of atitude change,report that having greater socioeconomic standing heightens support for environmental spending most among those in late-1930s birth cohorts,and less so subsequently. Blocker & Eckberg (1997) examine gender differences, finding women somewhat more apt than men to perceive environmental change as consequential, but no more likely to engage in proenvironmental activities.

Hadler's (2O13) five-society ISSP study makes both over-time and cross-national comparisons of environmental behaviors.Private actions like recycling rose, while public ones like petitioning and donations fell.The United States held a middle position on public behaviors but ranked lowest on private actions.

# Immigration

Since 1994,the GSS has asked whether immigration should be increased, reduced,or left unchanged. Our tabulations show a decline in the percentage favoring a decrease from above $6 0 \%$ (mid-1990s) to about $3 5 \%$ (2018). Chandler & Tsai's (2001) examination of 1994 data points to lower education, perceived threat to the English language,and political conservatism as notable factors associated with preferring a reduction. Both Smith & Kim (2O06)and Bonikowski & DiMaggio (2016) find that those expressng stronger nationalist sentiments favor increased limitations on immigration and hold negative attitudes about it.

# INTERGROUPATTITUDES

The GSS commenced in 1972 in the aftermath of 1960s civil rights activity,and in the midst of both the women's and gay liberation movements.It has since tracked attitudes regarding race— more generaly,ethnic—relations,gender roles,and sexual orientation.Allof these shifted,though unevenly, toward increased acceptance in the interim.

# Race and Ethnic Relations

Schuman et al. (1997) thoroughly examine trends through the mid-1990s in numerous aspects of racial atitudes in the GSS and other surveys; Bobo et al. (2O12) extend this using GSS data through 2Oo8. Many findings pertain to white Americans only, who widely and increasingly endorse principles of equal treatment in, for example, marriage,education,and employment; African Americans generally hold notably more prointegration views.

Implementation of these principles is a different matter. Among whites, Bobo et al. (2012) report low, slightly declining support for government policy that would improve black living standards; beliefs that there should be no“special favors”were much more prevalent. They highlight resistance to special treatment for blacks as a cornerstone of “racial resentment,”a “laissez-faire” orientation to racial isues. Opposition to preferential hiring ofblacks is high (above $8 0 \%$ among whites,and substantial (over $5 0 \%$ ）among blacks.Bobo & Kluegel (1993) show that both racetargeting (especiall) and focusing on equalizing outcomes rather than opportunities reduce white support for policy interventions.

Key to understanding many racial atitudes are beliefs about sources of black-white inequalities; those holding structurally oriented views tend toward more liberal stances than those with more individualistic understandings.Whites are most apt to attribute racial differences to individual motivational deficits, while blacks are inclined toward structural accounts involving discrimination or limited opportunity; some rise in motivational explanations among blacks is evident, however (Bobo et al.2012).Hunt (2007) found that Hispanic beliefs about bases of black-white inequality lie between those held by blacks and non-Hispanic whites.

Among notable predictors (other than race/ethnicity) of racial attitudes are age,cohort, education, gender,region,and religious beliefs (Hunt 20o7, Schuman et al.1997). Of these, education has drawn particular attention, partly because it is thought to promote generally more tolerant views (Bobo & Licari 1989).More education is linked with support for principles of equality, holding structural rather than individualistic inequality beliefs,and less stereotyping.Its relationship to policy implementation is weaker and less consistent (Schuman et al.1997). Wodtke (2012) suggests that education differences may reflect “ideological refinement”rather than “enlightenment.”

With the increasingly diverse racial/ethnic composition of the United States have come more analyses involving groups other than blacks and non-Hispanic whites,as both holders and objects of attitudes. Examples include Hunt's (2oo7) findings on inequality beliefs among Hispanics,and Wodtke's (2O12) analysis suggesting that education may not encourage rejection of stereotypes among Asians. Invoking both threat and contact theories,Dixon (2O06) finds that whites who live in places with higher fractions of blacks are more prone to negatively stereotype blacks—but less apt to do the same for Asians when situated near many Asians. Apart from these contextual variations,stereotyping is lower among those who have personal contacts within any given minority group.Xu & Lee (2013) show that many positive characteristics are ascribed to Asians,while Hispanics are negatively stereotyped in several respects. Both Asians and Hispanics continue to be seen as outsiders,regarded as,for example,less patriotic than persons in other race/ethnic groups.

# Gender Roles

GSS trends reveal that attitudes about suitable roles for women in and outside the home liberalized in the later twentieth century; Spitze & Huber (1980) trace trends in some items to the late 1930s.The rise leveled in the early 1990s. Brooks & Bolzendahl (2004) atribute much of this shift to cohort replacement,and a modest portion to changing labor force participation and marital status-while assigning substantial weight to the spread of a rights-oriented ideology that pertains to other domains including race/ethnicity. Cotter et al. (2011) atribute the mid-1990s stasis to the articulation and difusion of a competing“egalitarian essentialist” gender frame that combines an emphasis on traditional gender roles with feminist emphases on equality and choice.

Kane & Whipkey (2O09) detect a limited association between gender egalitarianism and support for alleviating gender inequality in employment; believing that government should intervene to redress inequality proved more important.Reminiscent of findings for race/ethnic policy measures, better-educated people were less apt to endorse interventions. Two studies report that holding gender-egalitarian views predicts identification as a“feminist,”most strongly so within the baby boom birth cohort.Schnittker et al. (2Oo3) atribute this to diverse interpretations of feminism by subsequent generations, or broadened acceptance of principles of gender equality. Peltola et al.(2Oo4) conjecture that it reflects different generational understandings of what feminism entails, together with varying dispositions toward individual and collective strategies for ameliorating gender inequalities.

# Sexual Orientation

Acceptance of homosexuality has changed rapidly over the period spanned by the GSS.Loftus (2001) showed that more than $7 0 \%$ of adults thought that same-sex relations were “always wrong" until about 1990;by 1998,less than $6 0 \%$ did so.This morality trend accelerated in the years since;in 2018,we estimate that $5 8 \%$ regard same-sex sexual relations as “not wrong at all."Loftus reported a steadier downward trend in willingness to deny civil liberties to homosexuals for 1973- 1998.Change in endorsement of same-sex marriage rights was similarly rapid; approval rose from $1 3 \%$ to $4 6 \%$ between 1988 and 2010 (Baunach 2012) and further to $6 8 \%$ in 2018.Views about homosexuality tended to be more negative in US states with a higher incidence of AIDS cases, especially in the earlier (1980s) phases of the epidemic (Ruel & Campbell 2006).

Both cohort replacement and intracohort change contribute to the liberalization of attitudes in this domain (Baunach 2011). Ohlander et al. (20o5) demonstrate that better-educated people are less apt to disapprove of homosexuality; mediating factors include greater cognitive sophistication and higher support for civil liberties.Reservations about same-sex marriage are increasingly concentrated among religious and political conservatives, whose views nevertheless liberalized—but more slowly than those of other groups (Sherkat et al.2011).

# SOCIAL CAPITAL AND SOCIAL NETWORKS

Putnam (2Oo0) based his argument that social capital declined in the late twentieth-century United States,in part,on trends in GSS data on memberships in voluntary groups,socializing with neighbors, family structure,job satisfaction,interpersonal trust, tolerance,and both racial and gender attitudes.Multidimensional analyses of GSS data on social capital trends include Paxton's (1999) mixed evidence of a decline: falling interpersonal trust, but no general drop in either associational memberships or institutional confidence.Schwadel & Stout (2012) reported period-and cohortrelated declines in trust,varying trends in informal association,and stability in organizational memberships.Utilizing GSS panel data,Glanville et al. (2O13) demonstrate that heightened informal socializing raises trust.Numerous other studies—notallconducted within the social capital framework—examine interpersonal trust, institutional confidence,and social networks as distinct phenomena.

# Interpersonal Trust

A falloff in generalized trust—the belief that most others are trustworthy,helpful,and fair—is evident over the GSS time frame.Robinson & Jackson (2O0l) attribute this primarily to acohortrelated drop among persons born after the 1940s,highlighting its implication that cohort replacement will lead to pervasive mistrust.Two studies ask whether higher state-level income inequality reduces trust,reaching different conclusions depending on the time period studied and the source of inequality data.Fairbrother & Martin (2013) find (for 1973-2004) that states where inequality rose more did not undergo greater drops in trust. Through 2012,Hastings (2018) ofers some evidence that rising state-level inequality does reduce trust.

Among many studies of individual variations in trust are several about the pronounced blackwhite difference (e.g.,Hughes & Thomas 1998,Smith 1997).Smith (1997) suggests that the lower levels of trust expressed by blacks may reflect distrust in whites, since the GSS trust question asks about “most people."Wilkes (2011) reports cohort variation and period-related declines in trust among whites that are either absent or muted among blacks.Simpson (2Oo6) finds Southern whites to be less trusting than Northern ones, suggesting that this reflects a more collectivist Southern culture; no similar regional diference emerged among blacks. While observing that dominant groups tend to be more trusting,Stets & Fares (O19) focus on racial/ethnic identification: Whites who identify strongly as such tend to have lower trust.

# Institutional Confidence

Smith (2012) comprehensively examines confidence in the 13 institutional domains tracked by the GSS.He reports declines for most, the military being an exception.Americans expressed most confidence in medicine and science,and least in media, organized labor, Congress,and the US presidency.Most confidence trends are not steady; they vary considerably across institutions, often correlating with events like elections,recessions,or scandals.

Others scrutinize particular institutional sectors.Pescosolido et al. (2oo1) find that confidence placed in medicine tracks that in science and education; healthier individuals who have health insurance were more apt to express positive sentiments about physicians. Gauchat (2012) demonstrates that confidence in science was generally stable but fell notably among political conservatives—especially better-educated ones—arguing that this reflects a politicization of science.Hooghe & Oser (2O17) show that those with strong partisan identities tend to be more confident in governmental institutions but have lower interpersonal trust, suggesting that strong identities are polarizing. Brooks & Cheng (2O01) find litle relationship between confidence in Congress or the presidency and policy preferences, concluding that falling confidence in government is largely symbolic and does not imply support for federal retrenchment.

# Social Networks and Connectivity

GSS measures and instruments provide substantial evidence about the extent and patterning of social connectedness in the United States. Its longest trend series record the reported frequency of spending“social evenings”with relatives,friends outside their neighborhood,and neighbors. Several studies (e.g.,Fischer 2O11) reveal declines in neighboring but stability or slight increases in the other two forms.

Burt's (1984) proposal led the GSS to conduct the first nationally representative survey of personal networks in 1985,using a name generator instrument eliciting persons with whom a respondent discusses “important matters."Marsden (1987) finds these networks to be small(median size 3),family centered,and socially homogeneous.Such relationships tend to be highly segregated by race,religious preference,and age,among other factors (Marsden 1988). Smith et al. (2014) report that intergroup contacts among race/ethnic and religious groups rose between 1985 and 2004,reflecting increased population diversity; underlying tendencies to associate with similar others largely persisted, however.

Considerable debate surrounded a 2004 replication of the 1985 study (McPherson et al.2006) that found a notable drop in the average size of these networks and an appreciable rise in the fraction of Americans claiming to have important discusions with no one.Paik & Sanchagrin (2013)atribute these changes to interviewer effects in the 2004 GSS.Fischer (2011) reviews a broad body of evidence about trends in relationships from the GSS and other surveys,concluding on balance that little change in ties with family and friends was evident during the later twentieth century.

DiPrete et al.(2O11) use reports of the number of contacts respondents have in various categories and social groups to study wider-ranging networks composed of acquaintances and trusted others.They estimate that US adults know a median of 550 others and trust a median of 17. Variations in numbers known are substantial, reflecting very appreciable social segregation along multiple dimensions including race,political orientation,and religious activity.

# HEALTHANDWELL-BEING

Though only a few ofits regularly repeated measurements—self-rated health,health as a spending priority,confidence in medicine—pertain to health,the GSS has nonetheless become a valued resource for studying health and illnes.Its wealth of sociodemographic background and attude information supports numerous investigations on social factors and health. Topical modules on sexual and other risky behaviors,perceptions of the mentally ill, genetic testing,and more also enhance its utility.

# Trends and Disparities in Self-Rated Health

The self-rating of health (SRH) administered in the GSS has been well validated in other studies that measure health conditions and outcomes.Much recent GSS-based research employs it to investigate trends in health disparities. Overall,Schnitker (2O07) reports a slight downward trend in SRH.This is positive among women,however, primarily by virtue of rising education. Women typically report lower SRH than men,but this gap has narrowed due to rising female labor force participation.Warren & Hernandez (2o07) find no change in the well-established socioeconomic gradient over time,though recent cohorts say thatthey have beter SRH.Schnittker (2004) reports a stronger positive association between education and SRH among those having lower incomes. Zheng's (2Oo9) analysis found that the likelihood of reporting poor health rose significantly with higher income inequality.

Analysis of 2011-2012 ISSP data (Hero et al.2017) revealed that income differences in reporting fair or poor SRH were larger in the United States than in almost allthe other 31 highand middle-income countries studied, excepting only Chile and Portugal. Gaps between high- and low-income Americans in perceiving cost-related barriers to obtaining needed treatment exceeded those in all the other high-income societies.

# Stigma and Conceptions of Mental Illness

A substantial research program summarized by Pescosolido (013) examines American views of persons with symptoms of mental illness,and stereotypes, prejudices,and discrimination involving mentally ill persons. Replicating a 1950s study in the 1996 GSS,Phelan et al.(2000) show that public conceptions of mental illness broadened somewhat beyond psychosis and anxiety or mood disorders,to encompass social deviance and cognitive impairment.Responses to factorial vignetes (Link et al.1999) revealed increased sophistication in recognizing mental health symptoms as mental illness.Little amelioration of stigma was evident, however: Indeed,more Americans regarded mentally ill persons—especially those with substance abuse disorders—as frightening and potentially violent,seeking to avoid them physically and socially. Willingness to support coercion into treatment was widespread.A further replication ten years later (Pescosolido etal.2O10) found that understanding of schizophrenia, major depression,and alcohol dependence in neurobiological terms rose—as did support for seeking treatment—but stigma did not decline.

# Sexual Behavior

The GSS began collcting information on sexual behavior via self-administered questionnaire in the later 1980s,after the onset of the AIDS epidemic; Smith (1992) reviews some attendant methodological issues.For late 1980s data,Smith (1991) reports that most American adults $( 6 5 \% )$ had one past-year sexual partner; $2 2 \%$ had none and $1 3 \%$ more than one.About $3 \%$ had casual or unfamiliar partners. Butler's (2Oo5) trend study found a rise in same-sex partnering—especially among women—between 1988 and 2002,noting that it coincided with a more tolerant normative climate. Monto & Carey (2014) compare young adults in 2004-2012 and in 1988-1994,finding no rise in sexual partners or frequency but some increase in casual/friend partners and a corresponding decline in regular ones.They question whether a pervasive“hookup culture"has arisen. Among many other studies of these data is that by Wiederman (1997) finding extramarital contacts to be higher among men than women.

# Happiness and Well-Being

Much research about subjective well-being relies on a GSS question asking if respondents are “very,”“pretty,”or “not too”happy. Overall happiness levels stayed largely stable from 1972 to 2018,though a very slight downward trend is detectable.Hout (2016) links this to rising income inequality, reporting largely stable happiness among the well-of, but a decline among the less affluent—especially in the wake of the Great Recession. Yang's (20o8) age-period-cohort decomposition finds that happiness rises with age and is lowest within the baby boom cohort; disparities favoring women, whites,and the better educated shrink with age. Stevenson & Wolfers (2008), too,note convergence in race and gender diferences,accompanied by educational differences that grow over time.

Expressed happiness is greater among married people and those with higher incomes. It also reflects social comparisons (Firebaugh & Tach 2012): Among those at a given income level, those with incomes lower than the average among their age peers tend to be unhappier. Among several studies connecting religious participation with health is that by Maselko & Kubzansky (2006), who report higher happiness and SRH—especially for men—among those engaged in public religious activities like attending services. Spiritual experiences had similar associations with greater happiness for women and men.

# Emotions

Extensive data on the frequency with which 19 emotions are experienced and on a recent episode of anger were assembled in a 1996 GSS topical module.Lively & Heise (2004) use these to demonstrate that the emotions measured reflect pleasant/unpleasant (e.g. overjoyed versus outraged), dominant/vulnerable (e.g., angry versus embarrassed), and active/quiescent (e.g., excited versus calm) contrasts. Simon & Nath (2Oo4) examine gender diferences in emotionality; when data are aggregated across all 19 reports, men and women experience emotions similarly often, but men are more apt to report positive states and women negative ones. Women are somewhat more likely than men to say that they express rather than suppress emotions they report feeling.

Several studies examine intergroup variations in the frequency, intensity,and duration of anger. Older people become angry less often (Schieman 1999); age differences in such factors as satisfaction with finances and family,attendance at religious services,sense of personal control, and health contribute to this.Stets & Tsushima (2Oo1) show that intimate group identities (e.g., family)callforth more intense but shorter episodes of anger than do less intimate role identities such as work.African Americans and whites exhibit no overall difference in the frequency of anger, but sense of control and mistrust are important moderators (Mabry & Kiecolt 2Oo5); for example, mistrust promotes anger among whites but not African Americans. Simon & Lively (2010) link the more intense and long-lasting anger experienced by women to their higher levels of depressive symptomatology.

# Well-Being at Work

Trends in perceived job security and job satisfaction are among the numerous work orientations tracked by the GSS.Security has undergone an uneven decline since 1972; Fullerton & Wallace (2007) link this to a“flexible turn”in US labor relations marked by deindustrialization and falling unionization.Kalleberg & Marsden (2012) show that aggregate perceptions of job security correspond closely with cycles in unemployment and that declines in security have been greater among white-collar than blue-collar workers—though the level of security remains lower for the latter. A study of the 2002-2014 period (Lowe 2018) found that the Great Recession had little effect on perceived security within a worker's current job, but did lower perceptions of one's more general employability security within the labor market.

By contrast, job satisfaction has remained essentially steady and relatively high throughout the period covered by the GSS.Firebaugh & Harley (1995) document this through the early 1990s, while Kalleberg & Marsden (2012) extend it through the mid-2000s; the trend continues through 2018.Kalleberg & Marsden report that satisfaction tends to be higher in times of higher unemployment and among those who perceive their jobs and financial situations to be secure. Blacks express lower job satisfaction than do whites; Tuch & Martin (1991) atribute this to race differences in job characteristics,rather than dispositional sources.

# CULTURE

While many GSS measures can be construed reasonably as reflections of culture in a broad sense,some focused studies of cultural phenomena emerged from topical modules that measured tastes—especially for musical genres—and activities.Many of these involve cultural diversity—or “omnivorousness”—as a resource and marker of distinction. Bryson (1996) shows that bettereducated, politically tolerant people generally exhibit broader tastes but tend to dislike genres associated with the less educated,thereby distancing themselves from the latter. Goldberg (2011) identifies three distinct taste frameworks espoused by different population segments, involving broad-narrow,“highbrow-lowbrow,”and "traditional-contemporary”contrasts of genres.Lizardo (2006) examines the interplay between diverse cultural tastes and social network size,finding that they generally reinforce one another; a caveat is that those involved in many highbrow activities tend to have more strong ties, while those participating widely in popular culture are apt to have more weak ones.

Turning to political culture, ISSP data show that Americans display high patriotism and national pride by comparison with residents of other countries (Smith & Kim 2O06).Bonikowski & DiMaggio’s (2O16) study of nationalism among Americans identifies two polar ("ardent”and “disengaged") types,together with intermediate ethnocultural ("restrictive") and civic varieties.

Levels of national pride,and the ardent and restrictive forms of nationalism, were more frequent in 2004 than in 1996; both articles atribute this to the influence of the September 11,2001,terrorist attacks.

# IMPACTSONMETHODOLOGY

The GSS employs state-of-the-art survey methods in pursuing its primary mission of supporting substantive research.Its data collection programs have led to numerous advances in methodology whose utility extends well beyond the GSS project. More than 125 Methodological Reports available from the GSS at http://www.gss.norc.org/ discuss both GSS-specific and more general issues of measurement and survey methodology.Its repeated cross-sectional design makes the GSS an attractive platform for implementing innovations in age-period-cohort analytic methods (Yang & Land 2013).

# Measuring Key Background Characteristics

Topical modules in 1989 and 2012 obtained respondent assessments of occupational social standing.Using the 1989 data,Nakao & Treas (1994) constructed occupational prestige and socioeconomic scores for 1980 Census occupational codes; Hout etal.(2015)did so with the 2012 data for the 2010 occupational clasification.These scores can be matched to occupational data in other studies.

The GSS's highly detailed data on denominational affliation within Protestantism callfor classification schemes that reflect their diversity within a manageable number of categories. Smith (1990a)develops a fundamentalist-moderate-liberal classfication that Steensland et al. (2000) critique and amend, distinguishing mainline, evangelical,and black Protestants alongside Catholic, Jewish, other,and unafiliated groups. In a symposium on religious measurement, Lehman & Sherkat (2O18) stress a church-sect distinction, proposing that denominational groupings should reflect theological exclusivity-universalism,and calling for separate sectarian,moderate,and liberal Protestant groups.

# Survey Methodology

The GSS has conducted numerous between-subjects ("split ballot") experiments assessing effects of survey question wording. Among these is one on national spending priorities that compares terse presentations (e.g.,“education"） with longer variants that often promise positive consequences ("improving the nation's education system"). Rasinski (1989) finds consistent diferences across the 1984-1986 GSSs for 3 of 15 policy areas; for example,“halting the rising crime rate” elicited more support than“law enforcement." Smith (1987) reports dramatically more support for“assistance to the poor”than for“welfare.”

Other comparisons examine efects of varying question formats.Alwin & Krosnick (1985) find that values for children were ordered similarly when measured by ranking alternatives and rating them. Measures based on ranked data were,however, more strongly correlated with criterion variables than were those using ratings. Elsewhere,Krosnick & Alwin (1987) report “primacy” effects-a tendency to select earlier-listed alternatives—in ranking tasks; these were stronger among respondents with lower cognitive sophistication. Alwin et al. (2018) use the GSS panel data to demonstrate that questions with fewer response categories,and without middle alternatives,have higher reliability.

Process data about interview conditions allow investigations of how respondent-interviewer interactions—among other circumstances—shape response content; some examples are cited above.Olson & Bilgen (2011) use these in showing that more experienced interviewers elicit more acquiescent answers.

# CONCLUSIONANDPROSPECT

Since its inception,the GSS project has built a prospectively assembled record of the current characteristics,backgrounds,behaviors,and attitudes of representative cross sections of American adults covering more than two generations and over a century of birth cohorts.As such,its data become increasingly valuable with each added round.

While this article does not aspire toward any broadly comprehensive statement about recent US social change,our review of GSS-based research findings suggests that one should take these elements into account:

■Inequality in socioeconomic standing based on socioeconomic origins persists and may be rising in some subgroups,while some race and gender disparities have shrunk. Perceived health status and overall happiness remained largely steady, but gaps in both related to socioeconomic status could be widening. Fewer Americans claim to have a religious afliation or participate in organized religionnotwithstanding stability in many religious beliefs—while intense religiosity persists. Acceptance of principles of equal treatment by race,modern rather than traditional roles for women, civil liberties,and the morality of homosexual relationships grew,though at uneven rates. Much diversity in views and few steady (or even monotonic) trends are apparent for many sociopolitical atitudes,including those related to balancing governmental and individual responsibility,intervening to reduce ascriptive inequalities,gun control,abortion rights and sexual morality (other than homosexual relationships),and environmental protection. Americans’ social ties to one another underwent little overall change—remaining highly segregated along racial, socioeconomic,religious,and other axes—while interpersonal trust fell. While few attitude distributions became more widely dispersed,certain social and political identities became increasingly consolidated,and partisan-related gaps in views about several sociopolitical issues rose.

Research bearing on these domains draws on many databases,of course.The GSS is important for all of them—and indispensable for some—due to its breadth of content, richness of background information,attention to over-time comparability of measurement,and extended observation period allowing even slow-moving trends to be recognized.Its participation in ISSP casts light on where the United States is—and is not—exceptional, while facilitating comparative srvey research.

Our review could not cover allsocial science fields that GSS research has advanced.Among those omitted are aging,family and living arrangements,life satisfaction,Internet use, knowledge of and attitudes toward science,and work-family conflict.

In keeping with the Annual Review of Sociology's mision,our article emphasizes research works that flow from the GSS.We should call attention to some its collateral contributions as well. Very widely utilized in teaching both research methods and substantive social science,the GSS is used in more than 2,0o textbooks and instructional manuals,and hundreds of thousands of students analyze it in coursework every year. More than 5,0oO theses and dissertations employ it. Every year, several thousand stories based on the GSS appear in the media.By virtue of its visibility, representativenessand high response rate,other surveys often use the GSS as a benchmark for comparison with their findings.Its research instruments are freely available to the research community and the project encourages their adoption.

Looking forward, we expect that the GSS will sustain its efforts to produce and disseminate data on US social trends,while remaining part of ISSP—which yields additional trend data through its periodic replications of modules covering the role of government, family and gender roles, the environment, national identity,and other subjects.Among anticipated near-term content innovations are topical modules on Internet (including social media) use and privacy,and on challenges of preserving freedom and civil liberties while protecting against terrorist threats. Collaboration with the American National Election Survey (ANES) willintroduce additional political/electoral behavior content into the GSS and a variety of GSS content into the ANES panel.

While respondent-provided survey data are the centerpiece of the GSS,linking them to archival and administrative data enhances their value.Such data refer to multiple levels of analysis (households,neighborhoods,and metropolitan areas)and come from diverse Census,commercial, and governmental sources. Recent GSS rounds make more such data linkages as part of a general multilevel, multisource (MLMS) strategy (Smith 2011).MLMS strategies augment respondentlevel data with social, economic,and environmental information that informs substantively oriented contextual analysis, aids in survey management, and provides added resources for detecting and adjusting for nonresponse bias.In these and other ways,future development of the GSS will further strengthen its capacity to support social science discovery that tracks and understands continuity and change in US society.

# DISCLOSURESTATEMENT

The authors have no financial conflicts of interest to disclose.Each of them was afiliated with the GSS project for an extended period,Marsden as a member of its Board of Overseers and later as a co-principal investigator from 1988-2O15,Smith as a researcher,director,and principal investigator from 1974-2020,and Hout as a member of its Board of Overseers (1992-2001) and later a co-principal investigator (2oo9-2017).

# ACKNOWLEDGMENTS

We are grateful for Derick Baum's assistance.We appreciate the helpful comments we received from Mary Ellen Marsden and an anonymous reviewer.

# LITERATURECITED

Adamczyk A,Valdimarsdótir M.2018.Understanding Americans'abortion attitudes: therole of the local religious context. Soc. Sci. Res.71:129-44 Alwin DF.1991.Family of origin and cohort differences in verbal ability.Am. Sociol.Rev.56(5):625-38 Alwin DF,Baumgartner EM,Beatie BA.2O18.Numberof response categories and reliability inattude measurement.J.Surv. Stat.Metbodol.6(2):212-39 Alwin DF, Krosnick JA.1985.The measurement of values in surveys: a comparison of ratings and rankings. Public Opin. Q.49(4):535-52 Alwin DF,McCammon RJ.1999.Aging versus cohort interpretations of intercohort diffrences in GSS vocabulary scores.Am. Sociol.Rev.64(2):272-86 Barkan SE.2014.Gender and abortion atitudes: religiosity as a suppressor variable.Public Opin.Q.78(4):940-   
50 Baunach DM.2011.Decomposing trends in attitudes toward gay marriage,1988-2006.Soc. Sci. Q.92(2):346-   
63 Baunach DM.2012.Changing same-sex marriage attitudes in America from 1988 through 2010.Public Opin. Q. 76(2):364-78 matter.Am. Sociol.Rev./4(4):50/-28   
Black DA,MakarHR,Sanders SG,TaylorLJ.2Oo3.The earnings efects ofsexual orientation.Ind.Labor Relat. Rev. 56(3):449-69   
Blocker TJ,Eckberg DL.1997. Gender and environmentalism: results from the 1993 General Social Survey. Soc. Sci. Q. 78(4):841-58   
Bobo L.1991.Social responsibility,individualism,and redistributive policies.Soc.Forum. 6(1):71-92   
Bobo L, Kluegel JR.1993.Opposition to race-targeting: self-interest,stratification ideology,or racialatitudes? Am. Sociol. Rev.58(4):443-64   
Bobo L,Licari FC.1989.Educationand political tolerance: testing the effects of cognitive sophistication and target group affect. Public Opim. Q. 53(3):285-308   
Bobo LD,Charles CZ,Krysan M,Simmons AD.2012.The real recordon racial attitudes.In Social Trends in American Life: Findings fromthe General Social Survey since 1972,ed.PV Marsden,pp.38-83.Princeton, NJ: Princeton Univ.Press   
Bolzendahl C,Brooks C.2Oo5.Polarization,secularization,ordiferences as usual? The denominational cleavage in U.S.social atitudes since the 1970s.Sociol. Q.46(1):47-78   
Bonikowski B,DiMaggio P. 2016. Varieties of American popular nationalism.Am. Sociol. Rev.81(5):949-80   
Brooks C,Bolzendahl C.2o04.The transformation of US gender role atitudes: cohort replacement, socialstructural change,and ideological learning. Soc.Sci. Res.33(1):106-33   
Brooks C, Cheng S. 20o1. Declining government confidence and policy preferences in the U.S.: devolution, regime effects,or symbolic change? Soc.Forces 79(4):1343-75   
Brooks C, Manza J. 2013.A broken public? Americans'responses to the Great Recession. Am. Sociol. Rev. 78(5):727-48   
Bryson B.1996.“Anything but heavy metal":symbolic exclusion and musical dislikes.Am. Sociol. Rev. 61(5):884-99   
Buchmann C,DiPrete TA.2006.The growing female advantage in college completion: the role of family background and academic achievement.Am. Sociol.Rev.71(4):515-41   
Burt RS.1984.Network items and the General Social Survey.Soc.Netw. 6(4):293-339   
Butler AC.2005. Gender diferences in the prevalence of same-sex sexual partnering: 1988-20o2.Soc. Forces 84(1):421-49   
Chandler CR,Tsai Y.2o01.Social factors influencing immigration atitudes: an analysis of data from the General Social Survey.Soc.Sci.7.38(2):177-88   
Chaves M.2oo4. Congregations in America.Cambridge,MA: Harvard Univ.Press   
Chaves MA.2O17.American Religion: Contemporary Trends.Princeton,NJ: Princeton Univ.Press   
Coter D,Hermsen JM, Vanneman R. 2011. The end of the gender revolution? Gender role atitudes from 1977 to 2008. Am. J. Sociol. 117(1):259-89   
Davis JA.1975. Communism, conformity,cohorts,and categories: American tolerance in 1954 and 1972-73. Am. J. Sociol. 81(3):491-513   
Davis JA.1992. Changeable weather in a coling climate atop the iberal plateau: conversion and replacement in forty-two General Social Survey items,197-1989.Public Opin. Q. 56(3):261-306   
Davis JA. 2013. A generation of atitude trends among US householders as measured in the NORC General Social Survey 1972-2010.Soc.Sci. Res.42(3):571-83   
Davis NJ,Robinson RV.1988.Class identification of men and women in the 1970s and 1980s.Am.Sociol. Rev. 53(1):103-12   
Dietz T,Stern PC,Guagnano GA.1998. Social structural and social psychological bases of environmental concern.Environ.Bebav.30(4):450-71   
DiMaggio P,EvansJ,Bryson B.1996.Have Americans'social atttudes become more polarized? Am.7.Sociol. 102(3):690-755   
DiPrete TA, Gelman A,McCormick T,Teitler J,Zheng T.2011. Segregation in social networks based on acquaintanceship and trust. Am.7. Sociol.116(4):1234-83   
DiPrete TA, Grusky DB.1990. Structure and trend in the process of stratification for American men and women. Am. J. Sociol. 96(1):107-43 of prejudice. Soc. Forces 84(4):2179-204   
Evans JH.2003.Have Americans'atitudes become more polarized?-An update.Soc. Sci. Q.84(1):71-90   
Fairbrother M, Martin IW.2013.Does inequality erode social trust? Results from multilevel models of US states and counties.Soc. Sci. Res. 42(2):347-60   
Felson J,Adamczyk A,Thomas C.2019.How and why have atitudes about cannabis legalization changed so much? Soc. Sci. Res.78:12-27   
Firebaugh G.1989.Methods for estimating cohort replacement effects.Sociol. Metbodol.19:243-62   
Firebaugh G,Harley B.1995.Trends in job satisfaction in the United States by race,gender,and type of occupation. Res. Sociol.Work 5:87-104   
Firebaugh G,TachL.2012.Income,age and happiness inAmerica.In Social Trends in American Life: Findings from the General Social Suruey Since 1972,ed.PVMarsden,pp.267-87.Princeton,NJ: Princeton Univ. Press   
FischerCS.2011.StillConnected: Family and Friends in Americasince 197o.New York: Russell SageFound.   
Fischer CS,Hout M.2o06.Century of Difference: How America Changed in the Last One Hundred Years.New York: Russell Sage Found.   
Fullerton AS,Wallace M.2007. Traversing the fexible turn: US workers’perceptions of job security,1977- 2002. Soc. Sci. Res.36(1):201-21   
Gauchat G. 2012.Politicization of science in the public sphere: a study of public trust in the United States, 1974 to 2010. Am. Sociol. Rev.77(2):167-87   
Glanville JL, Andersson MA, Paxton P. 2013.Do social connections create trust? An examination using new longitudinal data. Soc. Forces 92(2):545-62   
Goldberg A. 2O11. Mapping shared understandings using relational classanalysis: the case of the cultural omnivore reexamined.Am.J. Sociol. 116(5):1397-436   
Greeley AM.1989.Religious Change in America.Cambridge,MA: Harvard Univ.Press   
Greeley AM,Hout M.1999.Americans' increasing belief in life after death: religious competition and acculturation. Am. Sociol.Rev. 64(6):813-35   
Grusky DB,DiPrete TA.1990.Recent trends in the process of stratification.Demography 27(4):617-37   
Hadler M.2O13.Environmental behaviors in a transatlantic view: public and private actions in the United States,Canada,Germany,and the Czech Republic,1993-2010.Int.7. Sociol.43(4):87-108   
Harding DJ,Jencks C.2Oo3.Changing attitudes toward premarital sex: cohort,period,and aging effects. Public Opin. Q. 67(2):211-26   
Hastings OP.2018.Less equal,les trusting? Longitudinal andcross-sectional efects of income inequalityon trust in U.S. States,1973-2012. Soc. Sci. Res.74:77-95   
Hero JO,Zaslavsky AM, Blendon RJ.2017.The United States leads other nations in differences by income in perceptions of health and health care.Health Af 36(6):1032-40   
Hooghe M,OserJ.2O17.Partisan strength,political trustand generalized trustin the United States: ananalysis of the General Social Survey,1972-2014.Soc. Sci. Res.68:132-46   
Hout M.1988.More universalism,less structural mobility: the American occupational structure in the 1980s. Am.J. Sociol. 93(6):1358-400   
Hout M.199.Abortion politics in the United States,1972-1994: from single issue to ideology.Gend. Issues 17(2):3-34   
Hout M.2O16. Money and morale: growing inequality affects how Americans view themselves and others. Ann. Am. Acad. Political Soc. Sci. 663(1):204-28   
Hout M.2018.Americans' occupational status reflects the status of both of their parents.PNAS 115(38):9527- 32   
HoutM.2O20.Anewcompendiumof trends inthe General Social Survey1972-2018: period and cobort trends and differences byace,gender,education,urban-rraland regionfor276repeating items.GSSSoc.Change Rep. 64, NORC, Chicago   
Hout M,Fischer CS.2oo2.Why more Americans have no religious preference: politics and generations.Am. Sociol. Rev. 67(2):165-90   
Hout M,Greeley AM.1987.The center doesn't hold: church attendance in the United States,1940-1984. Am.Sociol.Rev. 52(3):325-45 Hm. J. S0c1ol.1U/(∠):400-)UU   
Hout M,Janus A.2011.Educational mobility in the United States since the 193Os.In Wbitber Opportunity? Rising InequalitySchols,and Children'sLife Chances,ed.GJDuncan,RJMurnane,pp.165-85.NewYork: Russell Sage Found.   
HoutM,Smith TW,MarsdenPV.2015.Prestigeand socioeconomic scoresforthe2010Census codes.GSSMethodol. Rep. 124, NORC, Chicago   
Huang M-H.2009.Race of the interviewer and the black-white test score gap.Soc. Sci. Res.38(1):29-38   
Hughes M,Thomas ME.1998.Thecontinuing significance ofrace revisited: a study ofrace,class,and quality of life in America,1972 to 1996.Am. Sociol.Rev. 63(6):785-95   
Hunt MO.2o07.African American,Hispanic,and white beliefs about black/white inequality,1977-2004.Am. Sociol. Rev.72(3):390-415   
Hunt MO,Ray R.2O12.Social class identification among black Americans: trends and determinants,1974- 2010.Am. Bebav. Sci. 56(11):1462-80   
Johnson EW,Schwadel P.2019.It is nota cohort thing: interrogating the relationship between age,cohort, and support for the environment. Enuiron.Bebav.51(7):879-901   
Kalleberg AL,Knoke D,Marsden PV,Spaeth JL.1996. Organizations in America: Analyzing Tbeir Structures and Human Resource Practices.Thousand Oaks,CA: SAGE   
Kalleberg AL,Marsden PV.2012.Labor force insecurity and U.S.work atitudes,1970s-2006.In Social Trends in AmericanLife:Findings fromthe General Social Survey Since 1972,ed.PVMarsden,pp.315-37. Princeton,NJ: Princeton Univ. Press   
Kane EW,Whipkey KJ. 2009. Predictors of public support for gender-related affirmative action: interests, gender attitudes,and stratification beliefs.Public Opin. Q.73(2):233-54   
Krosnick JA,Alwin DF 1987.An evaluation ofacognitive theory of response-order effects in survey measurement.Public Opin. Q. 51(2):201-19   
LehmanD,Sherkat DE.2018.Measuring religious identification in the United States.7.Sci. Study Religion 57(4):779-94   
Link BG,Phelan JC, Bresnahan M, Stueve A,Pescosolido BA.1999.Public conceptions of mentalilness: labels,causes,dangerousness,and social distance.Am.J.Public Health 89(9):1328-33   
Lively KJ,Heise DR.2004. Sociological realms of emotional experience.Am.7. Sociol.109(5):1109-36   
Lizardo O. 2006. How cultural tastes shape personal networks. Am. Sociol. Rev.71(5):778-807   
Loftus J.2001.America’s liberalization in atitudes toward homosexuality,1973 to 1998.Am. Sociol.Rev. 66(5):762-82   
Long DA,Kelly S,Gamoran A.2012.Whither the virtuous cycle? Past and future trends in black-white inequality in educational attainment. Soc.Sci. Res.41(1):16-32   
Lowe TS.2018.Perceived job and labor market insecurity in the United States: an assssment of workers' attitudes from 2002 to 2014.Work Occup.45(3):313-45   
Mabry JB,Kiecolt KJ.2oo5.Angerinblack and white: race,alienation,and anger.J. Health Soc.Behau.46(1):85- 101   
Manza J,Heerwig JA,McCabe BJ.2012. Public opinion in the“Age of Reagan": political trends 1972-2006. In Social Trends in American Life: Findings from tbe General Social Survey since 197,ed.PV Marsden, pp.117-45.Princeton,NJ: Princeton Univ. Press   
Marsden PV.1987.Core discussion networks of Americans.Am. Sociol. Rev.52(1):122-31   
Marsden PV.1988.Homogeneity inconfiding relations.Soc. Netw. 10(1):57-76   
Marsden PV,ed.2O12.Social Trends in American Life:Findings fromtbe General Social Survey since 1972. Princeton,NJ: Princeton Univ. Press   
Maselko J, Kubzansky LD. 2o06. Gender diferences in religious practices,spiritual experiences and health: results from the US General Social Survey. Soc. Sci. Med. 62(11):2848-60   
McCall L.2O13.Tbe Undeserving Rich:American Beliefs about Inequality，Opportunity，and Redistribution. Cambridge, UK: Cambridge Univ. Press   
McCright AM, Xiao C,Dunlap RE. 2014. Political polarization on support for government spending on environmental protection in the USA,1974-2012.Soc.Sci.Res.48:251-60   
Miller AS,Hottmann JP.1999.The growing divisivenes: culture wars or a war ot words? Soc. Forces 78(2):721- 45   
Miler AS,Stark R.2Oo2. Gender and religiousnes: can socialization explanations be saved? Am.7. Sociol. 107(6):1399-423   
Miller SV.2O19.What Americans think about gun control: evidence from the General Social Survey,1972- 2016. Soc. Sci. Q. 100(1):272-88   
Mize TD.2016.Sexual orientation in the labor market.Am. Sociol.Rev.81(6):1132-60   
Monto MA, Carey AG.2014. A new standard of sexual behavior? Are claims associated with the “hookup culture"supported by General Social Survey data? J. Sex Res.51(6):605-15   
Moore LM, Ovadia S.2o06.Accounting for spatial variation in tolerance: the effcts of education and religion. Soc. Forces 84(4):2205-22   
Nakao K, Treas J.1994. Updating occupational prestige and socioeconomic scores: how the new measures measure up. Sociol.Metbodol.24:1-72   
OhlanderJ,BatalovaJ,Treas J.2oo5.Explaining educational influences on atitudes toward homosexual relations. Soc. Sci. Res.34(4):781-99   
Olson K, Bilgen I. 2011. The role of interviewer experience on acquiescence. Public Opin. Q. 75(1):99- 114   
Osberg L,Smeeding T.20o6.“Fair" inequality? Atitudes toward pay diferentials: the United States n comparative perspective.Am. Sociol. Rev.71(3):450-73   
Owens LA,Pedulla DS.2014. Material welfare and changing political preferences: the case of support for redistributive social policies.Soc.Forces 92(3):1087-113   
Paik A,Sanchagrin K.2013.Social isolation in America: an artifact.Am.Sociol.Rev.78(3):339-60   
Pampel FC,Hunter LM. 2012. Cohort change,diffusion,and support for environmental spending in the United States.Am.7. Sociol.118(2):420-48   
Paxton P.1999.Is social capital declining in the United States?A multiple indicator asessment.Am.J.Sociol. 105(1):88-127   
Peltola P,Milkie MA,Presser S.2Oo4.The“feminist”mystique: feminist identity in three generations of women. Gender Soc.18(1):122-44   
Pescosolido BA.2013.The public stigma of mental illness: What do we think; what do we know; what can we prove? J.Health Soc.Bebav.54(1):1-21   
Pescosolido BA,Martin JK,Long JS,Medina TR,Phelan JC,Link BG.2010.“A disease like any other"? A decade of change in public reactions to schizophrenia, depression,and alcohol dependence.Am. J. Psychiatry 167:1321-30   
Pescosolido BA,Tuch SA,MartinJK.2001.The profession of medicine and the public: examining Americans' changing confidence in physician authority from the beginning of the“health care crisis”to the era of health care reform.7. Health Soc. Bebao.42(1):1-16   
Pfeffr FT,Hertel FR.2015.How has educational expansion shaped social mobility trends in the United States? Soc. Forces 94(1):143-80   
Phelan JC,Link BG, Stueve A,Pescosolido BA.20oo.Public conceptions of mental illness in 1950 and 1996: What is mental illnessand is it to be feared? J.Health Soc.Bebav.41(2):188-207   
PutnamRD.2ooo.Bowling Alone:The Colapse and RevivalofAmerican Community.New York: Simon &Schuster   
Rasinski KA.1989.The effect of question wording on public support for government spending. Public Opin. Q.53(3):388-94   
Robinson RV,Jackson EF.2001.Is trust in others declining in America? An age-period-cohort analysis. Soc. Sci. Res. 30(1):117-45   
Roth LM, Kroll JC.2O07.Risky busines: assessing risk preference explanations for gender differences in religiosity.Am. Sociol.Rev.72(2):205-20   
Ruel E, CampbellRT. 20o6.Homophobia and HIV/AIDS: atitude change in the face of an epidemic. Soc. Forces 84(4):2167-78   
Schieman S.1999.Age and anger.J. Health Soc. Behav.40(3):273-89   
Scnnittker J.zUvt.Laucauon and tne cnanging snape oI tne income gradient in neaitn. J. Heun Soc. benu. 45(3):286-305   
SchnittkerJ.20o7.Working more and feeling beter: women's health,employment,and family life,1974-2004. Am. Sociol. Rev.72(2):221-38   
SchnittkerJ,Freese J,Powell B.2O03.Who are feminists and what do theybelieve? The role of generations. Am. Sociol. Rev. 68(4):607-22   
Schuman H,Steeh C, Bobo L,Krysan M.1997.Racial Atitudes in America: Trends and Interpretations. Cambridge,MA: Harvard Univ. Press. Revis. ed.   
Schwadel P.2011. Age,period,and cohort effects on religious activitiesand beliefs.Soc.Sci.Res.40(1):181-92   
Schwadel P,Stout M. 2012.Age,period and cohort effects on social capital. Soc.Forces 91(1):233-52   
Sherkat DE,Elison CG.1997.The cognitive structure of a moral crusade: conservative Protestantism and opposition to pornography.Soc. Forces 75(3):957-80   
Sherkat DE,Ellison CG.2o07.Structuring the religion-environment connection: identifying religious influences on environmental concern and activism.7. Sci. Study Religion 46(1):71-85   
Sherkat DE,Powell-Willams M,Maddox G,de Vries KM.2011. Religion,politics,andsupport for same-sex marriage in the United States,1988-2008.Soc.Sci.Res.40(1):167-80   
Simon RW,LivelyK.2010.Sex,anger and depression. Soc.Forces 88(4):1543-68   
Simon RW,Nath LE.2004. Gender and emotion in the United States: Do men and women differ in selfreports of feelings and expressive behavior? Am.J. Sociol. 109(5):1137-76   
Simpson B.2006.The poverty of trust in the southern United States.Soc. Forces 84(3):1625-38   
SmithJA,McPherson M,Smith-LovinL.2014.Social distance intheUnited States: sex,race,religion,age, and education homophily among confidants,1985 to 2004.Am. Sociol. Rev.79(3):432-56   
Smith TW.1987.That which we call welfare by any other name would smellsweeter: an analysis ofthe impact of question wording on response patterns. Public Opin. Q.51(1):75-83   
Smith TW.1990a. Classifying Protestant denominations. Rev.Religious Res.31(3):225-45   
Smith TW.199ob.Liberal and conservative trends in the United States since World War II. Public Opin. Q. 54(4):479-507   
Smith TW.1991.Adult sexual behavior in 1989: number of partners,frequency of intercourse and risk of AIDS.Family Plann.Perspect.23(3):102-7   
Smith TW.1992.A methodological analysis ofthe sexual behavior questions on the General Social Surveys. J. Off. Stat. 8(3):309-25   
Smith TW.1997.Factors relating to misanthropy in contemporary American society.Soc.Sci. Res. 26(2):170- 96   
Smith TW. 2011.The report of the International Workshop on Using Multi-level Data from Sample Frames, Auxiliary Databases,Paradata and Related Sources to Detect and Adjust forNonresponse Bias in Surveys. Int.J.Public Opin.Res.23(3):389-402   
Smith TW.2012.Trends inconfidence ininstitutions,1973-2006.InSocial Trends in American Life:Findings from the General Social Survey since 1972,ed.PV Marsden, pp.177-211.Princeton,NJ: Princeton Univ. Press   
Smith TW, Kim S.2005.The vanishing Protestant majority.J. Sci. Study Religion 44(2):211-23   
Smith TW,Kim S.2006.National pride incomparative perspective: 1995/96 and 2003/04.Int.7.Public Opin. Res. 18(1):127-36   
Spitze G,HuberJ.1980.Changing atitudes toward women's nonfamily roles,1938 to1978.Sociol. Work Occup. 7(3):317-35   
Steensland B,Park JZ,Regnerus MD,Robinson LD,Wilcox WB,Woodberry RD.20oo.The measure of American religion: toward improving the state of the art. Soc. Forces 79(1):291-318   
Stets JE,Fares P.2019.The effects of race/ethnicity and racial/ethnic identification on general trust. Soc. Sci. Res. 80:1-14   
Stets JE,Tsushima TM. 2001. Negative emotion and coping responses within identity control theory. Soc. Psycbol. Q. 64(3):283-95   
Stevenson B,Wolfers J.2008.Happiness inequality in the United States.7. Leg. Stud.37(S2):S33-79   
StoufferSA.1955.Communism,Conformity,and CivilLiberties:A Cros-Section ofthe Nation Speaks Its Mind. Garden City,NY: Doubleday   
Svallfors S.1997.Worlds of welfare and atttudes to redistribution:a comparison of eight Western nations. Eur: Sociol.Rev.13(3):283-304   
TorcheF.2O11.Is acollege degree stillthe great equalizer? Intergenerational mobility across levels ofschooling in the United States.Am.7. Sociol.117(3):763-807   
Tuch SA,Martin JK.1991.Race in the workplace: black/white differences in the sources of job satisfaction. Sociol. Q.32(1):103-16   
Twenge JM,CarterNT,Campbell WK.2O15.Time period,generational,and age differences in tolerancefor controversial beliefs and lifestyles in the United States,1972-2012.Soc.Forces 94(1):379-99   
VannemanR,CannonLW.1987.Tbe American Perception of Class.Philadelphia: Temple Univ.Press   
Voas D,Chaves M.2O16.Is the United States a counterexample to the secularization thesis? Am.7. Sociol. 121(5):1517-56   
Warren JR,Hernandez EM. 2O07.Did socioeconomic inequalities in morbidity and mortality change in the United States over the course of the twentieth century? J.Health Soc.Bebau.48(4):335-51   
Weeden KA,Grusky DB.2012.The three worlds of inequality. Am.7. Sociol.117(6):1723-85   
Wiederman MW.1997.Extramarital sex: prevalence and correlates in a national survey.7.Sex Res.34(2):167- 74   
Wilkes R.2011.Re-thinking the decline in trust: a comparison of black and white Americans.Soc. Sci. Res. 40(6):1596-610   
Wodtke GT.2012.The impact of education on intergroup atitudes: a multiracial analysis. Soc.Psychol. Q. 75(1):80-106   
Wodtke GT.2O16.Social classand income inequality in the United States: ownership,authority,and personal income distribution from 1980 to 2010.Am.7. Sociol.121(5):1375-415   
Wright JD,Jasinski JL,Lanier DN.2O12. Crime, punishment,and social disorder: crime rates and public opinion over more than three decades.In Social Trends in American Life:Findings fromthe General Social Survey since 1972,ed.PVMarsden,pp.146-73.Princeton,NJ: Princeton Univ.Press   
XuJ,Lee JC.2013.The marginalized“model"minority:an empirical examinationof the racial triangulation of Asian Americans. Soc.Forces 91(4):1363-97   
Yamaguchi K, Wang Y. 20o2. Classidentification of married employed women and men in America. Am. J. Sociol. 108(2):440-75   
Yang Y.2008.Socialinequalities in happinessinthe United States,1972 to 2O04:anage-period-cohortanalysis. Am. Sociol. Rev.73(2):204-26   
Yang Y,Land KC.2Oo6.Amixed models approach to the age-period-cohort analysis of repeated cross-section surveys,with an application to data on trends in verbal test scores.Sociol.Metbodol.36:75-97   
YangY,Land KC.2013.Age-Period-Cobort Analysis:New Models,Metbods,and EmpiricalApplications.Boca Raton,FL: CRC Press   
Zheng H.2009. Rising U.S.income inequality,gender and individual self-rated health,197-2004.Soc. Sci. Med. 69(9):1333-42

# RELATED RESOURCES

Davis JA,Smith TW.1992.Tbe NORC General Social Survey: A User's Guide.Thousand Oaks,CA: SAGE   
Hout M,Hastings OP.2016.Reliability of the core items in the General Social Survey: estimates from the three-wave panels,2006-2014. Sociol. Sci.3:971-1002   
ISSP Secretariat (http://w.issp.org).The website of the International Social Survey Program provides data and documentation for the survey   
Marsden PV,Smith TW.2012.Appendix: the General Social Survey project.In Social Trends in American Life: Findings from tbe General Social Survey since 1972,ed.PVMarsden,pp.369-78.Princeton,NJ: Princeton Univ. Press   
NORC (https://gss.norc.org). NORC at the University of Chicago hosts a website containing data,documentation,and analysis tools for the General Social Survey   
SDA (Survey Documentation and Analysis) (https://sda.berkeley.edu).The SDA,supported by the Institute for Scientific Analysis,is a site that disseminates and provides online analysis facilities for many widely used social science databases, including the General Social Survey